/*
 * Decompiled with CFR 0.152.
 */
package com.affehund.voidtotem;

import com.affehund.voidtotem.ModConstants;
import com.affehund.voidtotem.PlatformHelper;
import com.affehund.voidtotem.VoidTotemFabric;
import com.affehund.voidtotem.api.VoidTotemEventCallback;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.List;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3545;

public class FabricPlatformHelper
implements PlatformHelper {
    @Override
    public String getPlatformName() {
        return "Fabric";
    }

    @Override
    public boolean isModLoaded(String modId) {
        return FabricLoader.getInstance().isModLoaded(modId);
    }

    @Override
    public class_1269 getVoidTotemEventResult(class_1799 itemStack, class_1309 livingEntity, class_1282 source) {
        return ((VoidTotemEventCallback)VoidTotemEventCallback.EVENT.invoker()).interact(itemStack, livingEntity, source);
    }

    @Override
    public class_1799 getTotemFromAdditionalSlot(class_1309 livingEntity, Predicate<class_1799> filter) {
        if (this.isModLoaded("trinkets")) {
            return TrinketsApi.getTrinketComponent((class_1309)livingEntity).map(component -> {
                List res = component.getEquipped(filter);
                return res.size() > 0 ? (class_1799)((class_3545)res.get(0)).method_15441() : null;
            }).orElse(null);
        }
        return null;
    }

    @Override
    public class_1792 getVoidTotemItem() {
        return VoidTotemFabric.VOID_TOTEM_ITEM;
    }

    @Override
    public void sendTotemEffectPacket(class_1799 itemStack, class_1309 livingEntity) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10793(itemStack);
        buf.writeInt(livingEntity.method_5628());
        if (livingEntity instanceof class_3222) {
            class_3222 player = (class_3222)livingEntity;
            ServerPlayNetworking.send((class_3222)player, (class_2960)ModConstants.TOTEM_EFFECT_PACKET_LOCATION, (class_2540)buf);
        }
        for (class_3222 player : PlayerLookup.tracking((class_3218)((class_3218)livingEntity.field_6002), (class_2338)livingEntity.method_24515())) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)ModConstants.TOTEM_EFFECT_PACKET_LOCATION, (class_2540)buf);
        }
    }

    @Override
    public class_2394 getVoidTotemParticle() {
        return VoidTotemFabric.VOID_TOTEM_PARTICLE;
    }

    @Override
    public List<? extends String> getBlacklistedDimensions() {
        return VoidTotemFabric.CONFIG.BLACKLISTED_DIMENSIONS;
    }

    @Override
    public boolean giveTotemEffects() {
        return VoidTotemFabric.CONFIG.GIVE_TOTEM_EFFECTS;
    }

    @Override
    public boolean isInvertedBlacklist() {
        return VoidTotemFabric.CONFIG.IS_INVERTED_BLACKLIST;
    }

    @Override
    public boolean needsTotem() {
        return VoidTotemFabric.CONFIG.NEEDS_TOTEM;
    }

    @Override
    public boolean showTotemTooltip() {
        return VoidTotemFabric.CONFIG.SHOW_TOTEM_TOOLTIP;
    }

    @Override
    public int teleportHeightOffset() {
        return VoidTotemFabric.CONFIG.TELEPORT_HEIGHT_OFFSET;
    }

    @Override
    public boolean useTotemFromInventory() {
        return VoidTotemFabric.CONFIG.USE_TOTEM_FROM_INVENTORY;
    }
}

